﻿using System;
using System.Collections.Generic;
using System.Net;
using System.Reflection;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

namespace NUnitTestRunnerWP7
{
    public class NUnitTestRunner
    {
        public static void Setup()
        {
            SetupRootVisual();
            TestsAssemblies.Add(Assembly.GetCallingAssembly());
        }

        public static void Setup(IEnumerable<Assembly> testAssemblies)
        {
            SetupRootVisual();
            TestsAssemblies.AddRange(testAssemblies);
            // By default the calling assembly is added to the list
            if (!TestsAssemblies.Contains(Assembly.GetCallingAssembly()))
            {
                TestsAssemblies.Add(Assembly.GetCallingAssembly());
            }
        }

        private static void SetupRootVisual()
        {
            var frame = new PhoneApplicationFrame();
            Application.Current.RootVisual = frame;
            frame.Source = new Uri("/NUnitTestRunnerWP7;component/MainPage.xaml", UriKind.Relative);
        }

        internal static List<Assembly> TestsAssemblies  = new List<Assembly>();
    }
}
